 #!/usr/bin/perl

# FILE:Mapping crosslinker to cytoscape
# AUTHOR: Jie Luo
# CREATE DATE: 1/25/08
# PROJECT: DSS crosslinking
# DESCRIPTION: to map the crosslinked peptide to cytoscape .NA files

$usage = "USAGE: Protein_crosslinked__results.pl <Summarized spectra file>

    This program will have the protein crosslinking display. so that it will be easily looked up by interesting users
  \n";

# Parse the command line.
if (scalar(@ARGV) != 1) {
  print(STDERR $usage);
  exit(1);
}


$inputFile = shift(@ARGV);


# Tell the user what we're going to do.
print(STDERR "map the croslinked peptide in $inputFile. \n");

@C= split ('\.xls', $inputFile);


my $title;


@newprotein;
%input_name;
@protein;
%protein_Sequence;
%peptide;
$aminoacid = 'AGSPVTCLINDQKEYMHFRWagspvtclindqkeymhfrw';
$symbol = '[]{}1234567890';
$size = 2000;
$BS3 = 138.06807;
$C_mod =  57.021464;
$Oxidation = 15.99491;
$proton = 1.00727646688;
$water = 18.0105646863;
$NH3 = 17.02654;
$neutron = 1.008664;
$BS3_240 = 240.15940;
$BS3_222 = 222.14884;

my $index;


open(OUTPUT1, ">@C[0].inter.protein.xls");
print OUTPUT1 ("index\tProtein-protein\tCrosslinkingsites\tXcorr\tDa\tppm\tspectrum\tengine\txcorr\tXcorr_norm\texpect\timmonium1\tion1\tdot1\tconnective1\tpeptide1\tprotein1\tUnique_protein1\tsubunit1\trealpep1\tposition1\timmonium2\tion2\tdot2\tconnective2\tpeptide2\tprotein2\tUnique_protein2\tsubunit2\trealpep2\tposition2\tCN\tComments\n");

open(OUTPUT2, ">@C[0].intra.protein.xls");
print OUTPUT2 ("index\tProtein-protein\tCrosslinkingsites\tXcorr\tDa\tppm\tspectrum\tengine\txcorr\tXcorr_norm\texpect\timmonium1\tion1\tdot1\tconnective1\tpeptide1\tprotein1\tUnique_protein1\tsubunit1\trealpep1\tposition1\timmonium2\tion2\tdot2\tconnective2\tpeptide2\tprotein2\tUnique_protein2\tsubunit2\trealpep2\tposition2\tCN\tComments\n");

open(INPUT, "<$inputFile") || die("Can't open $inputFile.\n");  
    $line = <INPUT>;
    chomp($line);
    my  @L = split (/\t/, $line);
    for ($i = 0; $i <@L ; $i ++ )  {
        $L[$i] =~ s/\s+//g;
     }


while ($line = <INPUT>) {
                 chomp($line);
                 my  @LL = split (/\t/, $line);
          

                for ($i = 0; $i <@LL ; $i ++ )  {
                   
                 $Column{$L[$i]} = $LL[$i]; 

                           }
   
  $Line{$Column{'index'}} = $line;
  $Xcorr{$Column{'index'}}= $Column{'xcorr'};

 
               my $P1 = $Column{'subunit1'}.':'.$Column{'position1'};
               my $P2 = $Column{'subunit2'}.':'.$Column{'position2'};
                my     @Cross = ($P1, $P2); my @D = sort @Cross;


    if ($Column{'type'} eq 'inter'  ) {
             my @inter = ($Column{'subunit1'}, $Column{'subunit2'}); my @Q =  sort @inter;
                       push @{$InterSpec{$D[0]}{$D[1]}}, $Column{'index'};
             }
    if ($Column{'type'} eq 'intra'  ) {
                            push @{$IntraSpec{$D[0]}{$D[1]}}, $Column{'index'};
             }



 #   if ($Column{'Unique_protein1'} < 2 && $Column{'Unique_protein2'} < 2 ){

             if ($Column{'xcorr'} > $XCORR{$D[0]}{$D[1]}) {$XCORR{$D[0]}{$D[1]} = $Column{'xcorr'}; }

           if ($Column{'type'} eq 'inter'  ) {
             my @inter = ($Column{'subunit1'}, $Column{'subunit2'}); my @Q =  sort @inter;
                    $Intercross{$Q[0]}{$Q[1]}{$D[0]}{$D[1]} ++;              
            }

            if ($Column{'type'} eq 'intra'  ) {                     
            $Intracross{$Column{'subunit1'}}{$D[0]}{$D[1]} ++;
      #     }

       }

  }

close INPUT;


my $interIndex; my $intraIndex; 
foreach $Pro1 (keys %Intercross)  {
      foreach $Pro2  (keys %{$Intercross{$Pro1}}) { $interIndex ++; 
         print OUTPUT1 ("$interIndex\t$Pro1---$Pro2\n");
          my $inter ;
         foreach $S1 (keys %{$Intercross{$Pro1}{$Pro2}} ) {
           foreach $S2 (keys %{$Intercross{$Pro1}{$Pro2}{$S1}} ) { $inter ++;
                  print OUTPUT1 ("\t$inter\t$S1---$S2\t$XCORR{$S1}{$S2}\n");
                 my %score;
                for ($i = 0; $i < @{$InterSpec{$S1}{$S2}}; $i ++ ) {
                  $score{$InterSpec{$S1}{$S2}[$i]} = $Xcorr{$InterSpec{$S1}{$S2}[$i]}; }

                foreach $key (sort {$score{$b} <=> $score{$a}} keys %score ) { 
  if ($Line{$key} ne '' ) {
                my @R = split (/\t/, $Line{$key});
                print OUTPUT1 ("\t\t\t\t");
                for ($j=2; $j<@R; $j ++) {
                print OUTPUT1 ("$R[$j]\t");}
                print OUTPUT1 ("\n");
              }
                  }
 
}}
$TotalInter += $inter;
}}

foreach $Pro (keys %Intracross)  {$intraIndex ++; 
 print OUTPUT2 ("$intraIndex\t$Pro\n"); my $intra ;
           foreach $S1 (keys %{$Intracross{$Pro}} ) {
           foreach $S2 (keys %{$Intracross{$Pro}{$S1}} ) { $intra ++;
                  print OUTPUT2 ("\t$intra\t$S1---$S2\t$XCORR{$S1}{$S2}\n");
                       
                 my %score;
                for ($i = 0; $i < @{$IntraSpec{$S1}{$S2}}; $i ++ ) {
                  $score{$IntraSpec{$S1}{$S2}[$i]} = $Xcorr{$IntraSpec{$S1}{$S2}[$i]}; }

                 foreach $key (sort {$score{$b} <=> $score{$a}} keys %score ) { 
               
                if ($Line{$key} ne '' ) {
                my @R = split (/\t/, $Line{$key});
                               print OUTPUT2 ("\t\t\t\t");
                for ($j=2; $j<@R; $j ++) {
                print OUTPUT2 ("$R[$j]\t");}
                print OUTPUT2 ("\n");
                  }
                  }

}}
$TotalIntra += $intra;
}


print OUTPUT1 ("Total inter crosslinks are: $TotalInter\n");

print OUTPUT2 ("Total intra crosslinks are: $TotalIntra\n");



close OUTPUT1;
close OUTPUT2;
























sub hashValueDescendingNum {
   $grades{$b} <=> $grades{$a};
}
sub hashValueAscendingNum {
   $grades{$a} <=> $grades{$b};
}



